local my_db_path = db_path or "./scripts/database/"; dofile(my_db_path..'/scripts/GT.lua')
dofile(my_db_path..'/chassis/static.lua')

-- SA-3 S-125
GT = {}

set_recursive_metatable(GT, GT_generic_stationary)
GT.chassis = chassis; chassis = nil

GT.visual.shape = "5P73_LAUNCH"
GT.visual.shape_dstr = "5P73_LAUNCH_p_1"

GT.id = 34609949

GT.sensor = {}
set_recursive_metatable(GT.sensor, SN_visual)
GT.sensor.height = 2.707
GT.sensor.max_range_finding_target = 50000
GT.sensor.min_range_finding_target = 4000
GT.sensor.max_alt_finding_target = 12000
GT.sensor.min_alt_finding_target = 20
GT.sensor.cos_angle_visibility_target = 0.819648

--Burning after hit
GT.visual.fire_size = 0.3 --relative burning size
GT.visual.fire_pos[1] = 0 -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0 -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0 -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 500 --burning time (seconds)

-- weapon systems
GT.WS = {}
GT.WS.maxTargetDetectionRange = 28000

GT.WS[inc_ws()] = {}
GT.WS.indirect_fire = true
GT.WS[ws].newZ = true
GT.WS[ws].center = 'CENTER_TOWER';
GT.WS[ws].depends_on_unit = {34628899,} -- Depends on unit e.g S-125 Radar
GT.WS[ws].pos = {0.00, 2.00, 0.00}  -- weapon system position X, Y, Z from the 3D model reference point
GT.WS[ws].maxBottom =  math.rad(10) -- weapon system min angle of fire / loading stage
GT.WS[ws].maxTop = math.rad(45) -- math.rad -- weapon system max angle of fire
GT.WS[ws].maxLeft = math.rad(90)
GT.WS[ws].maxRight = math.rad(-90)
GT.WS[ws].drawArgument1 = 0 -- 1st anim arg
GT.WS[ws].drawArgument2 = 1 -- 2nd anim arg
GT.WS[ws].omegaY = math.rad(5) -- horizontal speed of the launcher ramp
GT.WS[ws].omegaZ = math.rad(5) -- vertical speed of the launcher ramp
GT.WS[ws].reference_angle_Z =  math.rad(16) -- launcher vertical angle at start
GT.WS[ws].pidY = {p=10/GT.WS[ws].omegaY,i=1.5,d=18}
GT.WS[ws].pidZ = {p=10/GT.WS[ws].omegaZ,i=1.5,d=18}

-- launcher
set_recursive_metatable(GT.WS[ws], WS_5P73_launcher)
GT.WS[ws].LN[1].launch_delay = 60
GT.WS[ws].LN[1].ammunition_reserve = 4
GT.WS[ws].LN[1].PL[1].ammo_capacity = 4
GT.WS[ws].LN[1].PL[1].reload_time = 1800
GT.WS[ws].LN[1].PL[1].shot_delay = 60
GT.WS[ws].LN[1].PL[1].min_launch_angle = math.rad(16)
GT.WS[ws].LN[1].BR = {{connector_name = 'POINT_ROCKET_01',drawArgument = 4},{connector_name = 'POINT_ROCKET_02',drawArgument = 5},{connector_name = 'POINT_ROCKET_03',drawArgument = 6},{connector_name = 'POINT_ROCKET_04',drawArgument = 7},}


GT.CLSID = "{AE03B512-4198-4ae0-90D6-8921597BFEB8}"
GT.name = "SA-3 S-125 LN"
GT.displayname = _("SAM SA-3 S-125 LN")
GT.score = 5

register_car(
  {
        CLSID = GT.CLSID,
        Name = GT.name,
        DisplayName = GT.displayname,
        DetectionRange  = GT.sensor.max_range_finding_target,
        ThreatRange = GT.WS[1].LN[1].distanceMax,
        Rate = GT.score,
		mapclasskey = "P0091000082",
  }, 
  {
    register_car_cat("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "SAM"),
  }
);

